#include "AODVRuleSwitcher.h"
#include <string.h>
#include <arpa/inet.h>
#include <errno.h>
#include "../ipt_aodvext/ipt_aodvext.h"
#include "../../../voicehoc-utils/inc/Debug.h"

AODVRuleSwitcher::AODVRuleSwitcher()
{
	// Create the socket which will be used for modifying the rule
	if((sock = socket(AF_INET,SOCK_RAW,IPPROTO_RAW)) == -1){
		D_DEBUG("Failed to create socket!");
		D_CRITICAL(strerror(errno));
    	exit(1);
  	}
}

AODVRuleSwitcher::~AODVRuleSwitcher()
{
	close(sock);
}

void AODVRuleSwitcher::set(int val){
	// set the given value
	if(setsockopt(sock, IPPROTO_IP, RS_SOCKOPTNUM, &val,sizeof(int)) == -1){
		D_DEBUG("Failed to call setsockopt!");
		D_CRITICAL(strerror(errno));
	}
}

void AODVRuleSwitcher::enable(){
	// enable rule
	set(RS_ON);
}

void AODVRuleSwitcher::disable(){
	// disable rule (i.e. decrement counter)
	set(RS_OFF); 
}

int AODVRuleSwitcher::value(){
 	// get current value
	int size = sizeof(int);
	int val;
	if(getsockopt(sock, IPPROTO_IP, RS_SOCKOPTNUM, &val,(socklen_t*)&size) == -1){
		D_DEBUG("Error while calling getsockopt!");
		D_CRITICAL(strerror(errno));
	}else{
		return val;
	}
	return -1;
}
