package ch.ethz.inf.sct.uts.examples;

import ch.ethz.inf.sct.uts.annotation._

class FirstOrderFunctions {
	// Simple function taking another one as argument
  def f(m: Int => Int) {
    m(10) 
  }
  f(2*)
  
  
  // Return annotated object
  def g(m: => A @rep) : A @rep = {
    m
  }
  
  // Ok
  g({println("Creating A..."); new A @rep})
  
  // Not ok
  g({println("Creating A..."); new A @peer})
  
  class A
  
  
  // Function which takes arguments as argument
  def h(m: Int => B @rep, i: Int) {
    m(i)
  }
  
  // Ok
  h({i => println("Creating A..."); new (B @rep)(i)},1)
  
  // Ok
  h({println("Creating A..."); new (B @rep)(_)},1)
  
  // Not ok
  h({println("Creating A..."); new (B @peer)(_)},1)
  
  class B(val i: Int @any)
  
  // Take two annotated arguments
  def j(m: (C @rep, D @peer) => Boolean) {
    m(new C @rep, new D @peer)
  }
  
  j({(a: C @rep,b: D @peer) => true})
  
  // (Not yet) ok
  j({(a,b) => true})
  
  class C
  class D
}
