/*
 * This file is part the Universe Runtime Classes.
 *
 * Copyright (C) 2003-2005 Swiss Federal Institute of Technology Zurich
 *
 * Part of mjc, the MultiJava Compiler.
 *
 * Copyright (C) 2000-2005 Iowa State University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: UrtPolicy.java,v 1.3 2007/06/27 14:26:38 chalin Exp $
 */

package org.multijava.universes.rt;

/**
 * This interface has to be implemented by any class that is intended to
 * implement the policies needed for the Universe Runtime Checks.
 * 
 * @author scdaniel
 */
public interface UrtPolicy {
    /**
     * Defines how external objects (from non-universe aware code) are handled.
     * Are they peer?
     * 
     * @return	true if external objects should be handled as being peer
     */
    boolean isExternalPeer();
	
    /**
     * Defines the owner for Universe aware Objects that are created
     * from outside of Universe aware code.
     * 
     * Possibilities are a virtual native-set or the root set or ...
     * If null is returned, the implementation should default to something
     * reasonable (like registering the object peer with regards to the last
     * object).
     * 
     * @param obj	the object that needs an owner
     * 
     * @return	the owner
     */
    /*@ nullable @*/ Object getNativeOwner( /*@ nullable @*/ Object obj );
	
    /**
     * Defines what to do when a reference to the owner is requested and
     * the owner has already been collected.
     * 
     * @param obj	the Object whose owner has already been collected
     * 			and is now requested.
     * 
     * @return	the object to use as owner of obj
     */
    /*@ nullable @*/Object getCollectedOwner( /*@ nullable @*/Object obj );

    /**
     * Handles an illegal cast.
     */
    void illegalCast();

    /**
     * Handles an illegal array store.
     */
    void illegalArrayStore();
}
