/*
 * This file is part the Universe Runtime Classes.
 *
 * Copyright (C) 2003-2005 Swiss Federal Institute of Technology Zurich
 *
 * Part of mjc, the MultiJava Compiler.
 *
 * Copyright (C) 2000-2005 Iowa State University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: UrtDefaultPolicy.java,v 1.2 2005/06/12 20:05:00 wdietl Exp $
 */

package org.multijava.universes.rt.policy;

import org.multijava.universes.rt.UrtPolicy;
import org.multijava.util.Utils;

/**
 * This class defines how to handle errors and defines a few further policies.
 * 
 * Alternative implementations have to implement UrtPolicy.
 * 
 * @author scdaniel
 */
public class UrtDefaultPolicy extends Utils implements UrtPolicy {

    /**
     * Defines how external objects (from non-universe aware code) are
     * handled. i.e.: "Are they peer?"
     * 
     * @return	true if external objects should be handled as being peer
     */
    public boolean isExternalPeer () {
	return true;
    }
	
    /**
     * Universe objects generated from external code should be registered
     * as peer relative to the last object.
     * 
     * @return	null
     */
    public Object getNativeOwner (Object obj) {
	return null;
    }
	
    /**
     * If somebody asks for an already collected owner, return null.
     * 
     * @return	null
     */
    public Object getCollectedOwner (Object obj) {
	return null;
    }
	
    /**
     * Handles an illegal cast by throwing a ClassCastException.
     */
    public void illegalCast () {
	throw new ClassCastException();
    }
	
    /**
     * Handles an illegal array store exception by throwing an
     * ArrayStoreException.
     */
    public void illegalArrayStore () {
	throw new ArrayStoreException();
    }
}
