/*
 * This file is part the Universe Runtime Classes.
 *
 * Copyright (C) 2003-2005 Swiss Federal Institute of Technology Zurich
 *
 * Part of mjc, the MultiJava Compiler.
 *
 * Copyright (C) 2000-2005 Iowa State University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: UrtRelaxed.java,v 1.1 2005/06/12 19:38:28 wdietl Exp $
 */

package org.multijava.universes.rt.policy;

import org.multijava.universes.rt.UrtPolicy;

/**
 * Alternative implementation of UrtDefaultPolicy that does not throw an
 * error on casts from readonly objects that are illegal but just print a warning.
 * 
 * @author scdaniel
 */
public class UrtRelaxed
    extends UrtDefaultPolicy
    implements UrtPolicy {

    /**
     * Don't throw an error but just print a message.
     */
    public void illegalCast () {
	try {
	    throw new ClassCastException();
	} catch ( ClassCastException e ) {
	    System.err.println("Universe Warning: there has been an illegal cast from readonly!");
	    printException(e);
	}
    }
	
    /**
     * Don't throw an error but just print a message.
     */
    public void illegalArrayStore () {
	try {
	    throw new ArrayStoreException();
	} catch ( ArrayStoreException e ) {
	    System.err.println("Universe Warning: there has been an illegal write access to an array element!");
	    printException(e);
	}
    }

    /**
     * Print stack trace without the current function.
     * 
     * @param e	the exception
     */
    private void printException (Exception e) {
	StackTraceElement[] s = e.getStackTrace();
	for ( int i = 1; i < s.length; i++ )
	    System.err.println("    at " + s[i]);
    }
}
