package ch.ethz.inf.sct.uts.plugin.helloworld
import scala.tools.nsc._
import scala.tools.nsc.plugins._

/** Compiler plugin for the Scala compiler. */
class HelloWorldPlugin(val global: Global) extends Plugin {
  /** Name of this plugin. */
  val name = "helloworld"
    
  /** Description of this plugin. */
  val description = "Compiler plugin which prints out 'Hello, World!'"

  /** Components of this plugin. */
  val components = List(new HelloWorldPluginComponent(global))
    
  /** Handling of any plugin-specific options. */
  override def processOptions(options: List[String], 
      error: String => Unit) {
    options foreach {
      case o => error("Unknown option "+o+" for "+name) 
    }
  }
    
  /** A description of this plugin's options, for -help. */
  override val optionsHelp: Option[String] = None
}

/** Plugin component which runs after runsAfter. */
class HelloWorldPluginComponent (val global: Global) 
  extends PluginComponent {
  import global._
  /** Name of this compiler phase. */
  val phaseName = "helloworld-phase"
      
  /** When to execute this phase. */
  val runsAfter = "refchecks"
      
  /** Factory to create the new phase for the graph generation. */
  def newPhase(prev: Phase) = new Phase(prev) {
    def name = phaseName
      
    /** Process the compilation units. */
    def run {
      println("Hello, World!")
      currentRun.units foreach {u => println("Processing "+u.source.path)}
      println("Done.")
    }
  }
}
