package ch.ethz.inf.sct.uts.plugin.simpletraverser
import scala.tools.nsc._
import scala.tools.nsc.plugins._

/** Plugin component which runs after runsAfter. */
class SimpleTraverserPluginComponent (val global: Global) 
  extends PluginComponent {
  import global._
  /** Name of this compiler phase. */
  val phaseName = "simpletraverser-phase"
      
  /** When to execute this phase. */
  val runsAfter = "refchecks"
      
  /** Factory to create the new phase for the graph generation. */
  def newPhase(prev: Phase) = new Phase(prev) {
    def name = phaseName

    /** Process the compilation units. */
    def run {
			currentRun.units foreach { unit =>
				(new SimpleTraverser).traverse(unit.body)
      }
    }
  }
  
  /** A simple traverser which prints the name of the currently processed class/method */
  class SimpleTraverser extends Traverser {
    /** Method containing the pattern match. */
    override def traverse(tree: Tree) {
      tree match {
        case ClassDef(mods, name, tparams, impl) => 
          println("Processing class definition of "+tree.symbol+"...")
        case DefDef(mods, name, tparams, vparamss, tpt, rhs) =>
          println("Processing method definition of "+tree.symbol+"...")
        case _ => ()
      }
      super.traverse(tree)
    }
  }
}
