package ch.ethz.inf.sct.uts.examples

import ch.ethz.inf.sct.uts.annotation._

object Casts {
  def main(args : Array[String]) : Unit = {
    val a : C01 = new C02
    val b : C02 = if (a.isInstanceOf[C02]) {
      a.asInstanceOf[C02]
    }
    else {
      null
    }
    println("a: "+a+" b: "+b)

    // Should result in ClassCastException
    try {
      val c : C01 @peer = new (C02 @peer)
      val d : C02 @rep = c.asInstanceOf[C02 @rep]
      throw new Exception
    }
    catch {
      case ex: ClassCastException => println(ex.getMessage) 
    }
    
    // Should work
    val e : C01 @peer = new (C02 @peer)
    val f : C02 @peer = e.asInstanceOf[C02 @peer]
    println("e: "+e+" f: "+f)

		// Should work    
    val g : C01 @rep = new (C02 @rep)
    val h : C02 @rep = g.asInstanceOf[C02 @rep]
    println("g: "+g+" h: "+h)
    
    //  Should result in ClassCastException
    try {
      val c : C01 @rep = new (C02 @rep)
      val d : C02 @peer = c.asInstanceOf[C02 @peer]
      throw new Exception
    }
    catch {
      case ex: ClassCastException => println(ex.getMessage)
    }

    //  Should work    
    val i : C01 @any = new (C02 @rep)
    val j : C02 @rep = i.asInstanceOf[C02 @rep]
    println("i: "+i+" j: "+j)
    
    //  Should work    
    val k : C01 @any = new (C02 @peer)
    val l : C02 @peer = k.asInstanceOf[C02 @peer]
    println("k: "+k+" l: "+l)
    
    //  Should result in ClassCastException
    try {
      val m : C01 @any = new (C02 @rep)
      val n : C02 @peer = m.asInstanceOf[C02 @peer]
      throw new Exception
    }
    catch {
      case ex: ClassCastException => println(ex.getMessage)
    }
    
    //  Should result in ClassCastException
    try {
      val o : C01 @any = new (C02 @peer)
      val p : C02 @rep = o.asInstanceOf[C02 @rep]
      throw new Exception
    }
    catch {
      case ex: ClassCastException => println(ex.getMessage)
    }
    
    // Should work (but q.isInstanceOf[Int] is false in Scala!)
    val q : Double = 10.0
    val r : Int = q.asInstanceOf[Int]
    
    // Should work
    val s = "String"
    val t : String = if (s.isInstanceOf[String]) {
      s.asInstanceOf[String]
    }
    else {
      throw new Exception
    }
    
    println("Done.")
  }
}

class C01

class C02 extends C01