package ch.ethz.inf.sct.uts.examples.collection.stack

import ch.ethz.inf.sct.uts.annotation._

/** A simple stack */
class Stack[T <: Any @any] {
	private var stacktop : StackElement[T] @rep = null
  
  /** Push an element on the stack */
  def push(value: T) {
    stacktop = new (StackElement[T] @rep)(value, stacktop) 
  }
  
  /** Remove and return the topmost element */
  def pop = {
    val res = top
    if (stacktop != null) {
      stacktop = stacktop.next
    }
    res
  }
  
  /** Get the topmost element */
  def top = {
    if (stacktop != null) {
      stacktop.value
    }
    else {
      null.asInstanceOf[T]
    }
  }
  
  /** Check if the stack is empty */
  def empty = {
    stacktop == null
  }
  
  /** Container for the elements on the stack */
  class StackElement[T <: Any @any](val value : T, val next: StackElement[T] @peer)
}