/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: UTSTest.scala 883 2008-02-01 18:59:56Z ms $
 */
package ch.ethz.inf.sct.uts.test

import scala.tools.nsc.Main

import scala.testing.SUnit
import SUnit._
import ch.ethz.inf.sct.uts.test.helpers._

/**
 * Object used to execute some kind of unit-tests. The tests consist of an attempt to compile 
 * given source code and a comparison of the result (i.e. number of errors and warnings) to the expected values.
 * 
 * @author  Manfred Stock
 * @version $Revision: 883 $
 */
object UTSTest extends TestUtils with TestRunner {
  
  /**
   * Factory to create the actual test cases from the test data.
   */
  object CompilationTestFactory extends CompilationTestFactory {
    val options : List[String] = List("-P:uts-static:oam")
    val plugins : List[String] = List("target/uts-static.jar")
    val destination : String = "target/example-classes"
    val srcdir : String = "src/examples/scala/"
  }

  /**
   * Testdata - a list with classname, expected error/warning count and a name for the test case.
   */
  val testdata = List(
      ("ch.ethz.inf.sct.uts.examples.Arrays",                               0, 0, "Arrays"),
      ("ch.ethz.inf.sct.uts.examples.Casts",                                0, 0, "Casts"),
      ("ch.ethz.inf.sct.uts.examples.Defaulting",                           0, 0, "Defaulting"),
      ("ch.ethz.inf.sct.uts.examples.collection.map.MapNode",               0, 0, "MapNode"),
      ("ch.ethz.inf.sct.uts.examples.collection.map.Node",                  0, 0, "Node"),
      ("ch.ethz.inf.sct.uts.examples.collection.map.MapIter",               0, 0, "MapIter"),
      ("ch.ethz.inf.sct.uts.examples.collection.map.MapIterImpl",           0, 0, "MapIterImpl"),
      ("ch.ethz.inf.sct.uts.examples.collection.map.Map",                   0, 0, "Map"),
      ("ch.ethz.inf.sct.uts.examples.collection.stack.Stack",               0, 0, "Stack"),
      ("ch.ethz.inf.sct.uts.examples.collection.stack.StackTest",           0, 0, "StackTest"),
      ("ch.ethz.inf.sct.uts.examples.ExternalsCasts",                       0, 2, "ExternalsCasts"),
      ("ch.ethz.inf.sct.uts.examples.FirstOrderFunctions",                  3, 0, "FirstOrderFunctions"),
      ("ch.ethz.inf.sct.uts.examples.GCase",                                0, 1, "GCase"),
      ("ch.ethz.inf.sct.uts.examples.Generics",                             0, 0, "Generics"),
      ("ch.ethz.inf.sct.uts.examples.Generics2",                            0, 0, "Generics2"),
      ("ch.ethz.inf.sct.uts.examples.Generics3",                            0, 0, "Generics3"),
      ("ch.ethz.inf.sct.uts.examples.static.Generics4",                     1, 0, "Generics4"),
      ("ch.ethz.inf.sct.uts.examples.Generics5",                            0, 0, "Generics5"),
      ("ch.ethz.inf.sct.uts.examples.Generics6",                            1, 0, "Generics6"),    
      ("ch.ethz.inf.sct.uts.examples.Generics7",                            0, 0, "Generics7"),
      ("ch.ethz.inf.sct.uts.examples.Generics8",                            0, 0, "Generics8"),
      ("ch.ethz.inf.sct.uts.examples.Generics10",                           0, 0, "Generics10"),
      ("ch.ethz.inf.sct.uts.examples.InstanceOfTestsAndCasts",              0, 2, "InstanceOfTestsAndCasts"),
      ("ch.ethz.inf.sct.uts.examples.Lists",                                0, 0, "Lists"),
      ("ch.ethz.inf.sct.uts.examples.Math",                                 0, 0, "Math"),
      ("ch.ethz.inf.sct.uts.examples.OverLoading",                          0, 0, "OverLoading"),
      ("ch.ethz.inf.sct.uts.examples.Overriding",                           0, 1, "Overriding"),
      ("ch.ethz.inf.sct.uts.examples.Overriding2",                          0, 0, "Overriding2"),
      ("ch.ethz.inf.sct.uts.examples.Purity",                               1, 0, "Purity"),
      ("ch.ethz.inf.sct.uts.examples.Read",                                 0, 0, "Read"),
      ("ch.ethz.inf.sct.uts.examples.RuntimePlayground",                    0, 0, "RuntimePlayground"),
      ("ch.ethz.inf.sct.uts.examples.static.Anon",                          1, 0, "Anon"),
      ("ch.ethz.inf.sct.uts.examples.static.Assignment",                    4, 0, "Assignment"),
      ("ch.ethz.inf.sct.uts.examples.static.AssumedPurity",                 0, 0, "AssumedPurity"),
      ("ch.ethz.inf.sct.uts.examples.static.Blocks",                        2, 0, "Blocks"),
      ("ch.ethz.inf.sct.uts.examples.static.C",                             3, 0, "C"),
      ("ch.ethz.inf.sct.uts.examples.static.G",                            18, 0, "G"),
      ("ch.ethz.inf.sct.uts.examples.static.IfThenElse",                    2, 0, "IfThenElse"),
      ("ch.ethz.inf.sct.uts.examples.static.IfThenElse2",                   3, 0, "IfThenElse2"),
      ("ch.ethz.inf.sct.uts.examples.static.inference.Cycles",              1, 0, "Cycles"),
      (List(
          "ch.ethz.inf.sct.uts.examples.static.inference.InferenceExample",
          "ch.ethz.inf.sct.uts.examples.static.inference.UnitA",
          "ch.ethz.inf.sct.uts.examples.static.inference.UnitB",
          "ch.ethz.inf.sct.uts.examples.static.inference.SomeClass"
       ),                                                                   0, 0, "InferenceExample"),
      ("ch.ethz.inf.sct.uts.examples.static.inference.MatchInference",      0, 0, "MatchInference"),
      ("ch.ethz.inf.sct.uts.examples.static.inference.SimpleInference",     3, 0, "SimpleInference"),
      ("ch.ethz.inf.sct.uts.examples.static.inference.GenericsInference",   0, 0, "GenericsInference"),
      ("ch.ethz.inf.sct.uts.examples.static.inference.SubtypingInference",  0, 0, "SubtypingInference"),
      ("ch.ethz.inf.sct.uts.examples.static.Inheritance",                   4, 0, "Inheritance"),
      ("ch.ethz.inf.sct.uts.examples.static.Match",                         2, 0, "Match"),
      ("ch.ethz.inf.sct.uts.examples.static.Match2",                        3, 0, "Match2"),
      ("ch.ethz.inf.sct.uts.examples.static.MethodCalls",                   2, 0, "MethodCalls"),
      ("ch.ethz.inf.sct.uts.examples.static.Mixin",                         1, 0, "Mixin"),
      ("ch.ethz.inf.sct.uts.examples.static.NestedMethods",                 1, 0, "NestedMethods"),
      ("ch.ethz.inf.sct.uts.examples.static.Some",                          2, 0, "Some"),
      ("ch.ethz.inf.sct.uts.examples.static.StaticObject",                  5, 0, "StaticObject"),
      ("ch.ethz.inf.sct.uts.examples.static.TryCatchFinally",               3, 0, "TryCatchFinally"),
      ("ch.ethz.inf.sct.uts.examples.static.Traits",                        4, 0, "Traits"),
      ("ch.ethz.inf.sct.uts.examples.static.WFT2",                          1, 0, "WFT2"),
      ("ch.ethz.inf.sct.uts.examples.X",                                    0, 0, "X"),
      ("ch.ethz.inf.sct.uts.examples.Z",                                    0, 0, "Z")
  )
  
  /**
   * Create a testsuite with the tests that should be executed.
   * @return the created testsuite.
   */
	def suite = {
    CompilationTestFactory.dynOptions = testArgs
	  val suite = new TestSuite
    testdata foreach {
      case (cls: String,       errors, warnings, name) => suite.addTest(CompilationTestFactory.produce(cls,errors,warnings,name))
      case (cls: List[String], errors, warnings, name) => suite.addTest(CompilationTestFactory.produce(cls,errors,warnings,name))
    }
	  suite
  }
}